/**
* Copyright (C) 2012, Crestron Electronics, Inc.  All rights reserved.
* No part of this software may be reproduced in any form, machine or natural,
* without the express written consent of Crestron.
*
* \file     (See the name of this file.)
* \brief    .
* \detail   .
* \author   Richard Ting, Arto Kiremitdjian.
* \date     1/27/2012
* \warning  (None).
* \note     (None).
* \review   (Pending review).
**/
#pragma once // If supported by compiler, might speed-up builds.
#ifndef CRC_H_INCLUDED
#define CRC_H_INCLUDED

//-------------------------------------------------------------------------
// Include files.

//#include <windows.h>

//-------------------------------------------------------------------------
// Compatibility with both C and C++.

#ifdef __cplusplus
extern "C" {
#endif

//-------------------------------------------------------------------------
// Preprocessor defines.

//-------------------------------------------------------------------------
// Type definitions.

typedef u32 CrcValueType; // Type of CRC value.

//-------------------------------------------------------------------------
// Global function declarations.

void InitCRCLookupTable (void);
CrcValueType CalculateRunningCRC (unsigned char const *const data, u32 const datasize, bool initialRun);

//-------------------------------------------------------------------------
#ifdef __cplusplus
}
#endif

#endif // CRC_H_INCLUDED
